terraform {
    required_providers {
        linode = {
            source = "linode/linode"
            version = "1.29.3"
        }
    }
}

provider "linode" {
    token = var.token
}

resource "linode_instance" "nomad_servers" {
    count = var.server_count
    image = var.linode_image
    label = "nomad-server-${count.index + 1}"
    group = "nomad-test-instances"
    region = var.region
    type = var.server_type
    authorized_keys = var.ssh_keys
    root_pass = var.root_password
    private_ip = true

    interface {
        purpose = "public"
    }

    interface {
        purpose = "vlan"
        label = "vlan-${var.region}-1"
        ipam_address = "10.8.0.${count.index + 1}/24"
    }

    connection {
        type = "ssh"
        user = "root"
        host = self.ip_address
        private_key = file("~/.ssh/id_rsa")
    }

    provisioner "file" {
        source = "scripts/nomad-installations.sh"
        destination = "/tmp/nomad-installations.sh"
    }

    provisioner "remote-exec" {
        inline = [
            # Add executable permission to the script, the execute it.
            "chmod +x /tmp/nomad-installations.sh",
            "/tmp/nomad-installations.sh"
        ]
    }
}

resource "linode_instance" "nomad_clients" {
    count = var.client_count
    image = var.linode_image
    label = "nomad-client-${count.index + 1}"
    group = "nomad-test-instances"
    region = var.region
    type = var.client_type
    authorized_keys = var.ssh_keys
    root_pass = var.root_password
    private_ip = true

    depends_on = [linode_instance.nomad_servers]

    interface {
        purpose = "public"
    }

    interface {
        purpose = "vlan"
        label = "vlan-${var.region}-1"
        ipam_address = "10.8.0.${count.index + 11}/24"
    }

    connection {
        type = "ssh"
        user = "root"
        host = self.ip_address
        private_key = file("~/.ssh/id_rsa")
    }

    provisioner "file" {
        source = "scripts/nomad-installations.sh"
        destination = "/tmp/nomad-installations.sh"
    }

    provisioner "remote-exec" {
        inline = [
            # Add executable permission to the script, the execute it.
            "chmod +x /tmp/nomad-installations.sh",
            "/tmp/nomad-installations.sh"
        ]
    }
}

resource "null_resource" "nomad_servers_post_script" {
    count = var.server_count
    depends_on = [linode_instance.nomad_servers]

    connection {
        type = "ssh"
        user = "root"
        password = var.root_password
        host = linode_instance.nomad_servers[count.index].ip_address
        private_key = file("~/.ssh/id_rsa")
    }

    provisioner "file" {
        source = "scripts/nomad-server-setup.sh"
        destination = "/tmp/nomad-server-setup.sh"
    }

    provisioner "remote-exec" {
        inline = [
            # Add executable permission to the script, the execute it.
            "chmod +x /tmp/nomad-server-setup.sh",
            "/tmp/nomad-server-setup.sh ${count.index + 1} ${var.server_count} ${var.region}"
        ]
    }
}

resource "null_resource" "nomad_clients_post_script" {
    count = var.client_count
    depends_on = [linode_instance.nomad_clients, null_resource.nomad_servers_post_script]

    connection {
        type = "ssh"
        user = "root"
        password = var.root_password
        host = linode_instance.nomad_clients[count.index].ip_address
        private_key = file("~/.ssh/id_rsa")
    }

    provisioner "file" {
        source = "scripts/nomad-client-setup.sh"
        destination = "/tmp/nomad-client-setup.sh"
    }

    provisioner "remote-exec" {
        inline = [
            # Add executable permission to the script, the execute it.
            "chmod +x /tmp/nomad-client-setup.sh",
            "/tmp/nomad-client-setup.sh ${count.index + 11} ${var.server_count} ${var.region}"
        ]
    }
}
